#include <jsc/client_config.hpp>

#include <fstream>
#include <string>

#include <nlohmann/json.hpp>

#include <jsc/error.hpp>

namespace jsc {

ClientConfig ClientConfig::from_file(std::string const &path) {
  std::ifstream file{path};
  if (!file)
    throw ConfigError{"config file", "cannot open"};

  nlohmann::json obj;
  file >> obj;
  return from_json(obj);
}

ClientConfig ClientConfig::from_string(std::string const &str) {
  auto obj = nlohmann::json::parse(str);
  return from_json(obj);
}

ClientConfig ClientConfig::from_json(nlohmann::json const &obj) {
  ClientConfig config;

  if (obj.contains("ra_url")) {
    config.ra_url = obj["ra_url"].get<std::string>();
  }
  if (obj.contains("ra_service_name")) {
    config.ra_service_name = obj["ra_service_name"].get<std::string>();
  }
  if (obj.contains("ra_pods_info")) {
    config.ra_pods_info = obj["ra_pods_info"].get<std::string>();
  }
  if (obj.contains("ra_uid")) {
    config.ra_uid = obj["ra_uid"].get<std::string>();
  }
  if (obj.contains("ra_key_negotiation")) {
    config.ra_key_negotiation = obj["ra_key_negotiation"].get<bool>();
  }
  if (obj.contains("ra_need_token")) {
    config.ra_need_token = obj["ra_need_token"].get<bool>();
  }
  if (obj.contains("ra_policy_id")) {
    config.ra_policy_id = obj["ra_policy_id"].get<std::string>();
  }
  if (obj.contains("bytedance_top_info")) {
    config.bytedance_top_info = obj["bytedance_top_info"].get<std::string>();
  }

  if (obj.contains("attest_interval")) {
    config.attest_interval = obj["attest_interval"].get<int>();
  }

  if (obj.contains("root_key_config")) {
    config.root_key_config =
        obj["root_key_config"].get<std::map<std::string, std::string>>();
  }

  if (obj.contains("log_dir")) {
    config.log_dir = obj["log_dir"].get<std::string>();
  }

  if (obj.contains("vbs_preference")) {
    config.vbs_preference = obj["vbs_preference"].get<int>();
  }

  return config;
}

} // namespace jsc
