#pragma once

#include <map>
#include <string>
#include <type_traits>

#include <nlohmann/json_fwd.hpp>

namespace jsc {

struct ClientConfig {
  std::string ra_url = "";

  std::string ra_service_name = "";

  std::string ra_pods_info = "";

  std::string ra_uid = "";

  bool ra_key_negotiation = true;

  bool ra_need_token = true;

  std::string ra_policy_id = "";

  std::string bytedance_top_info = "";

  int attest_interval;

  std::map<std::string, std::string> root_key_config;

  std::string log_dir;

  /// 0: 不使用 VBS.
  /// 1 (默认): 通过 IsEnclaveTypeSupported(ENCLAVE_TYPE_VBS) Windows API
  ///           判断系统是否支持 VBS, 若支持则使用 VBS.
  /// 2: 总是使用 VBS. 若使用 VBS 时出错, 则回退到普通版.
  int vbs_preference = 1;

  /// 从文件读取配置.
  __declspec(dllexport) static ClientConfig from_file(std::string const &path);

  /// 从字符串读取配置.
  __declspec(dllexport) static ClientConfig from_string(std::string const &);

  /// 从 JSON 对象读取配置.
  __declspec(dllexport) static ClientConfig from_json(nlohmann::json const &);
};

// 可以默认构造
static_assert(std::is_default_constructible_v<ClientConfig>);
// 可以析构
static_assert(std::is_nothrow_destructible_v<ClientConfig>);
// 可以复制
static_assert(std::is_copy_constructible_v<ClientConfig> and
              std::is_copy_assignable_v<ClientConfig>);
// 可以移动
static_assert(std::is_move_constructible_v<ClientConfig> and
              std::is_move_assignable_v<ClientConfig> and
              std::is_swappable_v<ClientConfig>);

} // namespace jsc
