#pragma once

#include <string>

#include <httplib.h>
#include <nlohmann/json_fwd.hpp>

namespace jsc {
namespace detail {

struct TopInfo {
  std::string ak;
  std::string sk;
  std::string service;
  std::string region;
  std::string method;
  std::string action;
  std::string version;

  std::string host;
  std::string url_rewrite;

  static TopInfo from_json(nlohmann::json const &);
};

httplib::Params build_top_params(TopInfo const &top_info);

httplib::Headers build_top_headers(TopInfo const &top_info,
                                   std::string const &host,
                                   std::string const &path,
                                   std::string const &body);

httplib::Result
request_bytedance_gateway(TopInfo const &top_info, std::string const &path,
                          std::string &&body,
                          httplib::Headers &&additional_headers);

} // namespace detail
} // namespace jsc
