#pragma once

#ifdef JSC_CRYPTO_OPENSSL
#error "Wrong compilation flag"
#endif

#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <winenclave.h> // Needed by bcrypt.h

#include <cstdint>
#include <vector>

#include <bcrypt.h>

#include <jsc/detail/cipher.hpp> // IWYU pragma: export
#include <jsc/detail/utils.hpp>

namespace jsc {
namespace detail {

static inline void BCryptCloseAlgorithmProvider0(void *alg) {
  (void)BCryptCloseAlgorithmProvider(alg, 0);
}
using BCRYPT_ALG_ptr = unique_ptr_with<void, BCryptCloseAlgorithmProvider0>;

static inline void BCryptDestroyKey0(void *key) { (void)BCryptDestroyKey(key); }
using BCRYPT_KEY_ptr = unique_ptr_with<void, BCryptDestroyKey0>;

struct BCryptKeyPair {
  BCRYPT_ALG_ptr alg;
  BCRYPT_KEY_ptr key;
};

struct BCryptEncryptContext {
  BCRYPT_ALG_ptr alg;
  BCRYPT_KEY_ptr key;
  BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO cipher_info;
  std::vector<uint8_t> iv;
  std::vector<uint8_t> tag;
  std::vector<uint8_t> partial_block;
  uint8_t partial_block_len;
  std::vector<uint8_t> block_state;
  std::vector<uint8_t> tag_state;
};

struct bcrypt_cipher_impl {
  using rsa_key = BCryptKeyPair;
  using sym_key = std::vector<uint8_t>;
  using encrypt_ctx = BCryptEncryptContext;
  using decrypt_ctx = BCryptEncryptContext;
};

} // namespace detail

} // namespace jsc
