#pragma once

#include <cstddef> // For size_t
#include <cstdint>
#include <string>
#include <string_view>
#include <vector>

namespace jsc {
namespace detail {

__declspec(dllexport) std::string base64_encode(uint8_t const *in, size_t len);

inline std::string base64_encode(std::vector<uint8_t> const &v) {
  return base64_encode(v.data(), v.size());
}

__declspec(dllexport) std::vector<uint8_t> base64_decode(std::string_view);

__declspec(dllexport) std::string base64_decode_string(std::string_view);

__declspec(dllexport) std::string hex_encode(uint8_t const *in, size_t len);

inline std::string hex_encode(std::vector<uint8_t> const &v) {
  return hex_encode(v.data(), v.size());
}

} // namespace detail
} // namespace jsc
