#pragma once

#include <cstdint>
#include <stdexcept> // For runtime_error
#include <string_view>
#include <vector>

#include <openssl/bio.h>
#include <openssl/bn.h>
#include <openssl/evp.h>

#include <jsc/detail/utils.hpp>

namespace jsc {
namespace detail {

using BIO_ptr = unique_ptr_with<BIO, BIO_vfree>;

using BN_ptr = unique_ptr_with<BIGNUM, BN_free>;

using EVP_CIPHER_CTX_ptr = unique_ptr_with<EVP_CIPHER_CTX, EVP_CIPHER_CTX_free>;

using EVP_MD_CTX_ptr = unique_ptr_with<EVP_MD_CTX, EVP_MD_CTX_free>;

using EVP_PKEY_ptr = unique_ptr_with<EVP_PKEY, EVP_PKEY_free>;

using EVP_PKEY_CTX_ptr = unique_ptr_with<EVP_PKEY_CTX, EVP_PKEY_CTX_free>;

// Error reporting

std::runtime_error openssl_error(char const *origin);

// Public key conversion

EVP_PKEY_ptr parse_rsa_public_key(std::string_view pem);

std::vector<uint8_t> rsa_public_key_to_blob(EVP_PKEY const &pkey);

} // namespace detail
} // namespace jsc
