#pragma once

#include <memory> // For unique_ptr

namespace jsc {
namespace detail {

// Smart pointer

template <typename T, void f(T *)>
struct deleter {
  void operator()(T *p) const { f(p); }
};

template <typename T, void f(T *)>
using unique_ptr_with = std::unique_ptr<T, deleter<T, f>>;

} // namespace detail
} // namespace jsc
