#pragma once

#include <array>
#include <cstddef> // For size_t
#include <stdexcept>
#include <string>
#include <string_view>

namespace jsc {

template <size_t N>
static std::string format_error_message(std::string e,
                                        std::array<std::string_view, N> args) {
  for (auto const &s : args) {
    e.append(s.data(), s.size());
  }
  return e;
}

class ConfigError : public std::runtime_error {
public:
  ConfigError(std::string_view config_name, std::string_view message)
      : std::runtime_error{format_error_message<3>(
            "Config error: ", {config_name, ", ", message})} {}
};

class ParamError : public std::runtime_error {
public:
  ParamError(std::string_view param_name, std::string_view message)
      : std::runtime_error{format_error_message<3>(
            "Param error: ", {param_name, ", ", message})} {}
};

class StateError : public std::runtime_error {
public:
  StateError(std::string_view message)
      : std::runtime_error{
            format_error_message<1>("State error: ", {message})} {}
};

class CryptoError : public std::runtime_error {
public:
  CryptoError(std::string_view message)
      : std::runtime_error{
            format_error_message<1>("Crypto error: ", {message})} {}
};

class ServiceError : public std::runtime_error {
public:
  ServiceError(std::string_view service_name, std::string_view message)
      : std::runtime_error{format_error_message<3>(
            "Service error: ", {service_name, ", ", message})} {}
};

} // namespace jsc
