#define __declspec(x)

#define WINAPI __stdcall

#ifdef __cplusplus
extern "C" {
#else

// wchar_t is built-in for C++
typedef unsigned short wchar_t;

#endif

// https://github.com/openssl/openssl/blob/openssl-3.4.0/util/platform_symbols/windows-symbols.txt

// processthreadsapi.h
#define GetCurrentProcessId vbs_GetCurrentProcessId
#define GetCurrentThreadId vbs_GetCurrentThreadId

unsigned WINAPI vbs_GetCurrentProcessId();
unsigned WINAPI vbs_GetCurrentThreadId();

// processenv.h (via winbase.h)
#define GetEnvironmentVariableW vbs_GetEnvironmentVariableW
#define GetStdHandle vbs_GetStdHandle

unsigned WINAPI vbs_GetEnvironmentVariableW(wchar_t const *lpName,
                                            wchar_t *lpBuffer, unsigned nSize);
void *WINAPI vbs_GetStdHandle(unsigned nStdHandle);

// stdlib.h
#define getenv vbs_getenv

char *vbs_getenv(char const *varname);

// winnls.h
#define GetACP vbs_GetACP

unsigned WINAPI vbs_GetACP();

// sysinfoapi.h
#define GetSystemTimeAsFileTime vbs_GetSystemTimeAsFileTime

struct _FILETIME;
void WINAPI
vbs_GetSystemTimeAsFileTime(struct _FILETIME *lpSystemTimeAsFileTime);

// synchapi.h
#define Sleep vbs_Sleep

void WINAPI vbs_Sleep(int dwMilliseconds);

// fileapi.h

#define FindFirstFileW vbs_FindFirstFileW
#define FindNextFileW vbs_FindNextFileW
#define FindClose vbs_FindClose
#define GetFileType vbs_GetFileType
#define WriteFile vbs_WriteFile

struct _WIN32_FIND_DATAW;
void *WINAPI vbs_FindFirstFileW(wchar_t const *lpFileName,
                                struct _WIN32_FIND_DATAW *lpFindFileData);
int WINAPI vbs_FindNextFileW(void *hFindFile,
                             struct _WIN32_FIND_DATAW *lpFindFileData);
int WINAPI vbs_FindClose(void *hFindFile);
unsigned WINAPI vbs_GetFileType(void *hFile);
struct _OVERLAPPED;
int WINAPI vbs_WriteFile(void *hFile, void const *lpBuffer,
                         unsigned nNumberOfBytesToWrite,
                         unsigned *lpNumberOfBytesWritten,
                         struct _OVERLAPPED *lpOverlapped);

// sys/stat.h
#define _stat64i32 vbs__stat64i32

struct _stat64i32;
int vbs__stat64i32(char const *path, struct _stat64i32 *buffer);

// time.h
// time() and gmtime_s() are static inline functions that delegate to _time64()
// and _gmtime64_s()
#define _time64 vbs__time64
#define _gmtime64_s vbs__gmtime64_s

long long vbs__time64(long long *destTime);
struct tm;
int vbs__gmtime64_s(struct tm *tmDest, long long const *sourceTime);

#ifdef __cplusplus
}
#endif

#pragma warning(disable : 4028)
#pragma warning(disable : 4142)
