class CryptoRAGErrorCode:
    INVALID_PARAM = 10000
    KEY_ERROR = 10001
    EXCEED_LIMIT_SIZE = 10002
    ENC_ERROR = 10003
    DEC_ERROR = 10004
    JSC_ERROR = 10005
    APP_NOT_FOUND = 10006
    ACCOUNT_ID_MISS = 10007
    RDS_ERROR = 20000
    API_ERROR = 10100
    Uninitialized = 10200

class CryptoRAGErrorMsg:
    INVALID_PARAM = "Invalid parameter"
    INVALID_JSON = "Invalid JSON format"
    KEY_ERROR = "Unable to acquire key"
    EXCEED_LIMIT_SIZE = "Exceed parameter limit size"
    ENC_ERROR = "Encryption error"
    DEC_ERROR = "Decryption error"
    JSC_ERROR = "Jeddak Secure Channel error"
    APP_NOT_FOUND = "RagAppID not found"
    ACCOUNT_ID_MISS = "X-Top-Account-Id is missing in the request header"
    RDS_ERROR = "Operate database error"
    API_ERROR = "API not found"

class CryptoRAGError(Exception):
    def __init__(self, code: int, message: str):
        self.code = code
        self.message = f"code: {code}, message: {message}"
    
    def __str__(self):
        return self.message
    