import { describeProject, searchEditMaterial, updateProject, getEffectList, submitEditTaskAsync, deleteEditMaterial, createEditMaterial, updateMediaPublishStatus, searchVideo, getVideoPlayInfo, mGetMaterial, uploadMaterial } from './actions.js';

window.veveditor = new window.VeVEditor({
  container: document.getElementById('editor'),
  config: {
    projectId: '', // 这里需要修改为实际的火山视频点播剪辑项目ID
    groupId: '', // 这里需要修改为实际的火山视频点播剪辑Group ID
    region: 'cn-north-1', // 这里需要修改为实际的火山视频点播区域，暂只支持cn-north-1区域
    autoPublish: true,
    material: {
      show: true,
      enableLocalUpload: true,
      emptyIcon: './static/upload.svg',
      uploadAccept: 'image/*,.mp3,.mp4,.webm',
      videoAccept: '.mp4,.webm',
    },
    filter: {
      show: true,
    },
    transition: {
      show: true,
    },
    effect: {
      show: true,
    },
    text: {
      show: true,
      enableAnimation: true,
    },
    header: {
      show: true,
      isProjectNameEditable: true,
      isNavBackVisible: true,
      isProjectSubmitVisible: true,
    },
  },
  actions: {
    searchVideo,
    mGetMaterial,
    describeProject,
    updateProject,
    searchEditMaterial,
    getEffectList,
    submitEditTaskAsync,
    deleteEditMaterial,
    createEditMaterial,
    updateMediaPublishStatus,
    getVideoInfo: getVideoPlayInfo,
  },
  handlers: {
    uploadMaterial,
    onNavBack: () => {
      console.log('cus-> onNavBack');
    },
    onUploadMaterial: () => {
      console.log('cus-> onUploadMaterial');
    },
    onProjectSubmit: () => {
      console.log('cus-> afterProjectSubmit');
    },
  },
});
